require( "scripts/style.lua" );

is_endless = false;

gTrackingLevel = gTrackingLevel + 1;

if ( not (tonumber(GetState("LatestLevelStory")) == nil)) then
	if (tonumber(GetState("LatestLevelStory")) < gLevel) then
		SetState("LatestLevelStory", gLevel);
	end;
else 
	SetState("LatestLevelStory", gLevel);
end;

SetState("StoryModeSessionTime",1);
SetState("MainMenuScreenTime",0);
SetState("ComicScreenTime",0);
SetState("MetaMapTime",0);
SetState("HelpScreenTime",0);

function ChangeLevel(score)
	gLevel = gLevel + 1;
	gScore = gScore + score;
		
	if (gLevel == 11) then
		SwapToModal("scripts/metamap.lua");
	elseif (gLevel == 21) then
		SwapToModal("scripts/metamap.lua");
	elseif (gLevel == 31) then
		SwapToModal("scripts/metamap.lua");
	elseif (gLevel == 41) then
		SwapToModal("scripts/metamap.lua");
	else
		if gLevel==51 then
			gComic = 6;
			gComicPage = 1;
			gComicMaxPage = 1;
			SwapToModal("scripts/comics.lua");
		elseif gLevel>51 then
			SwapToModal("scripts/welcome.lua");
		else 
			SwapToModal("scripts/loading.lua");
			--SwapToModal("scripts/level.lua");
		end;
	end
end

function FirstPeekCompleted()
	DisplayDialog{
		"scripts/ok.lua",
		title = "endtrial",
		body = "endtrialconfirm",
	};
	SendGameMessage( "quit" );
end

function UpgradesDialog()
	if (prepareOptions(gLevel) > 0) then
		DoModal("scripts/upgrades.lua");
	else
		CreateUpgradesSnapshot();
	end
end

function ExitToMainMenu()
	SendGameMessage( "quit" );
end

function Restart()
	SwapToModal("scripts/loading.lua");
end

vLevel_SkipTutorialButtonGraphics=
{
	"buttons/skiptutorial.png",
	"buttons/skiptutorial.png",
	"buttons/skiptutorial.png",
}

MakeDialog
{
	-- Name the modal dialog
	name = "Before test",
	Bitmap
	{
		name  = "backgroundimage",
		image = "backgrounds/background_parking_placeholder";

		scale = 1.0,
		w	  = 100,
		h	  = 100,
		
		Level
		{
			x	= kCenter,
			y	= kCenter,
			w	= kMax,
			h	= kMax,

			level		= gLevel,
			totalscore	= gScore,
			tracking_level = gTrackingLevel,
			fadespeed   = 0.75;
			
			SetStyle(ButtonStyle),
			Button
			{
				name	= "skiptutorial",
				font	=  {
							 standardFont,
							 22,
							 Color(0,0,0,255)
						   },
				x		= kCenter,
				y		=   5,
				w		= 150,
				label	= "skiptutorialtitle",
				graphics = 
					{ 
						"buttons/long_button_up",
						"buttons/long_button_down",
						"buttons/long_button_over" 
					},
				command	= function()
							DisplayDialog{
								"scripts/yesno.lua",
								yes   = function()
											SkipTutorial();
										end,
								title = "skiptutorialtitle",
								body  = "skiptutorialconfirm",
							};
						  end;
			},
			---------- win button --------------
			SetStyle(ButtonStyle),
			Button
			{
				label 	= "continue",
				name	= "endgame_win",
				font	=  {
							 standardFont,
							 16,
							 BlackColor
						   },
				x		= 470+26,
				y		= 400-4,
				hflip   = true,
				graphics = { "buttons/btn_a_normal","buttons/btn_a_down","buttons/btn_a_over" },
				command	= function()
							SendGameMessage("win_level");
						  end;
			},
			---------- fail button  --------------
			SetStyle(ButtonStyle),
			Button
			{
				label 	= "retry",
				name	= "endgame_retry",
				font	=  {
							 standardFont,
							 16,
							 BlackColor
						   },
				x		= 470+26,
				y		= 400-4,
				hflip   = true,
				graphics = { "buttons/btn_a_normal","buttons/btn_a_down","buttons/btn_a_over" },
				command	= function()
							SendGameMessage("win_level");
						  end;
			},
			---------- main menu button  --------------
			SetStyle(ButtonStyle),
			Button
			{
				label 	= "quit",
				name	= "endgame_mainmenu",
				font	=  {
							 standardFont,
							 16,
							 BlackColor
						   },
				x		= 235-23,
				y		= 400-4,
				graphics = { "buttons/btn_a_normal","buttons/btn_a_down","buttons/btn_a_over" },
				command	= function()
							SendGameMessage("quit");
						  end;
			},
			--------------------------------------------------------------------------------------------------------------------------------------------
			Text
			{
				name	= "text_openclose",
				x		= 757,
				y 		= 110,
				w		= 50,
				h		= 30,
				flags 	= kHAlignCenter + kVAlignTop,
				label   = "open",
				font	= { standardFont, 12, BlackColor },
			},
			--------------------------------------------------------------------------------------------------------------------------------------------
			-- Bitmap
			-- {
				-- image 	= "buttons/base_pause",
				-- x		= 0,
				-- y 		= 563,
			-- },
			SetStyle(ButtonStyle),
			Button
			{
				name	= "pause_button",
				label	= "pause",
				font	=  {
							 standardFont,
							 16,
							 BlackColor
						   },
				x		= kMax-107,
				y		= kMax-32,
				graphics = 
					{ 
						"buttons/btn_pause_norm",
						"buttons/btn_pause_down",
						"buttons/btn_pause_over" 
					},
				command	= function()
							SendGameMessage("pause");
							DoModal("scripts/pause.lua");
						  end;
			},
			-- Bitmap
			-- {
				-- image 	= "buttons/btn_pause_shadow",
				-- x		= 0,
				-- y 		= 568,
			-- },
			---------- win screen elements END-----------------------------------------------------------------------------------------------------------------------
			
			Bitmap
			{
				name 	= "blackfader",
				image   = "backgrounds/blackfull.png",
				x = kCenter,
				y = kCenter,
				w = kMax,
				h = kMax,				
			},
			
		},
		
	},
}

